#ifndef ELEMENT_H
#define ELEMENT_H

#include <stdbool.h> // type booléen (bool: true/false): renvoyé par ElementEstValide et ElementComparer
#include <stdlib.h> // pour la constante NULL

// Définit un type Element, comme char*
typedef char* Element;

// la constante element_invalide
const static Element element_invalide = (Element)NULL;

// - les opérations (fonctions):

// Vérifie la validité d'un élément
// @param E: Element à vérifier
// @return true si E est valide, faux sinon
bool ElementEstValide(Element E); 

// Affiche un élément
// @param E: élément à afficher
// @Note affiche <INVALIDE> en cas d'élément invalide
void ElementAfficher(Element E);

// Compare deux éléments
// @param E1, E2: les deux éléments à comparer
// @return true si E1 et E2 sont égaux, faux sinon
// @Note si E1 et E2 sont tous les deux invalides, la fonction renvoie true
bool ElementComparer(Element E1, Element E2);

// Effectue une copie profonde d'un élément (donc allocation de mémoire)
// @param E: élément à copier
// @return nouvel élément avec le même contenu que E. 
//         Renvoie element_invalide si E n'est pas valide
// @Note l'élément renvoyé peut être détruit par appel à la fonction free.
//       Voir aussi la fonction ElementDetruire qui le fait proprement
Element ElementCopie(Element E);

// Destruction d'un élement (libération de mémoire)
// @param E: élément à détruire
// @return element_invalide
// @Note fonctionne même si E est invalide
Element ElementDetruire(Element E);

#endif // ELEMENT_H
