// fichier copie.c
#include <stdio.h>

int main(int argc, char *argv[])
{
   char fichierIn[]="reels.txt";
   char fichierOut[]="reels_copie.txt";

   FILE *fIn, *fOut;
   float val;

   // ouvre le premier fichier en lecture
   fIn = fopen(fichierIn, "r");
   
   // test si tout s'est bien passe
   if (!fIn)
     {
       fprintf(stderr, "Impossible d'ouvrir le fichier %s en lecture\n", fichierIn);
       return 2;
     }

   // si on est la, c'est que tout va bien. On ouvre le deuxieme fichier en ecriture
   fOut = fopen(fichierOut,"w");
   // on test encore si tout est ok
   if (!fOut)
     {
       fprintf(stderr, "Impossible d'ouvrir le fichier %s en ecriture\n", fichierOut);
       return 3;
     }

   // realise la copie: on suppose que le fichier ne contient que des valeurs reelles
   while (fscanf(fIn, "%f", &val) == 1)
     fprintf(fOut, "%f\n", val);

   // ferme les fichiers ouverts
   fclose(fIn);
   fclose(fOut);

   return 0;
}
