function [ C, T ] = fastcartoontexture( Ima, sigma )
% Matlab implementation of   
% A. Buades, T. M. Le, J.-M. Morel, and L. A. Vese, 
% "Fast cartoon + texture image filters" 
% IEEE Transactions on Image Processing 
% vol. 19, no. 8, pp. 1978–1986, 2010.


sIma=size(Ima);
df = 1/sIma(1);
if (mod(sIma(1),2))
    f1=(-1/2+df/2:df:1/2-df/2)';
else
    f1=(-1/2:df:1/2-df)';
end
df = 1/sIma(2);
if (mod(sIma(2),2))
    f2=(-1/2+df/2:df:1/2-df/2);
else
    f2=(-1/2:df:1/2-df);
end
X=ifftshift(repmat(f1,1,sIma(2)));
Y=ifftshift(repmat(f2,sIma(1),1));
fftL = 1./(1+(2*pi*sigma).^4*(X.^2+Y.^2).^2);
    
if (ndims(Ima)==2)

    Gx=diff(Ima([end 1:end],:),1,1); 
    Gy=diff(Ima(:,[end 1:end]),1,2); 
    EucNorm=sqrt(Gx.^2+Gy.^2);
    LTV=ifft2(fft2(EucNorm).*fftL,'symmetric');

    Imab=ifft2(fft2(Ima).*fftL,'symmetric');
    Gxb=diff(Imab([end 1:end],:),1,1); 
    Gyb=diff(Imab(:,[end 1:end]),1,2); 
    EucNormb=sqrt(Gxb.^2+Gyb.^2);
    LTVb=ifft2(fft2(EucNormb).*fftL,'symmetric');

else
    
    LTV=zeros(size(Ima,1),size(Ima,2));
    LTVb=zeros(size(Ima,1),size(Ima,2));
    Imab=zeros(size(Ima));
    for n=1:3
        ImaComp=Ima(:,:,n);
        Gx=diff(ImaComp([end 1:end],:),1,1); 
        Gy=diff(ImaComp(:,[end 1:end]),1,2); 
        EucNorm=sqrt(Gx.^2+Gy.^2);
        LTV=LTV+ifft2(fft2(EucNorm).*fftL,'symmetric');
        Imab(:,:,n)=ifft2(fft2(ImaComp).*fftL,'symmetric');
        Gxb=diff(Imab([end 1:end],:,n),1,1); 
        Gyb=diff(Imab(:,[end 1:end],n),1,2); 
        EucNormb=sqrt(Gxb.^2+Gyb.^2);
        LTVb=LTVb+ifft2(fft2(EucNormb).*fftL,'symmetric');
    end
  
end

lambda= 1 - LTVb./LTV;
a1=0.25;
a2=0.5;
wlambda=zeros(size(lambda));
wlambda(lambda>a1)=(lambda(lambda>a1)-a1)/(a2-a1);
wlambda(lambda>a2)=1;
wlambda=repmat(wlambda,1,1,size(Ima,3));

C=wlambda.*Imab+(1-wlambda).*Ima;
T=Ima-C;


end
  
