% script for using the function NoLoDuDoCT.m
% "A Non-Local Dual-Domain Approach to Cartoon and Texture Decomposition"
% Frederic Sur
% IEEE Transactions on Image Processing
% 2019

% first, add flann to path:
% addpath(genpath('flann-1.8.4-src'))
% (also add image directory to Matlab's path)


% Experiments presented in the same order as the companion report available here: 
% https://members.loria.fr/FSur/software/NoLoDuDoCT/NoLoDuDoCT_experiments.pdf


clear all, close all;
Ima=imread('barbara.png');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [300,190;33,235;425,433;470,160;26,545]);


clear all, close all;
Ima=imread('barbara.png');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [300,190;33,235;425,433;470,160;26,545], 32, 2, 1000);


clear all, close all;
Ima=imread('barbara.png');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [], 16 );


clear all, close all;
im_gt=double(imread('texmos3.s512.tiff'));
%im_gt=im_gt(1:end-1,:,:);
[x,y]=meshgrid(1:size(im_gt,2),1:size(im_gt,1));
PNoise=zeros(size(im_gt,1),size(im_gt,2));
PNoise(1:size(im_gt,1)/2,1:size(im_gt,2)/2) = 60*sin(2*pi*128/size(im_gt,1)*x(1:size(im_gt,1)/2,1:size(im_gt,2)/2)).*sin(2*pi*32/size(im_gt,2)*y(1:size(im_gt,1)/2,1:size(im_gt,2)/2));
PNoise(size(im_gt,1)/2+1:end,1:size(im_gt,2)/2) = 60*sin(2*pi*128/size(im_gt,1)*x(size(im_gt,1)/2+1:end,1:size(im_gt,2)/2));
PNoise(1:size(im_gt,1)/2,size(im_gt,2)/2+1:end) = 60*sin(2*pi*64*sqrt(2)/size(im_gt,2)*(x(1:size(im_gt,1)/2,size(im_gt,2)/2+1:end)+y(1:size(im_gt,1)/2,size(im_gt,2)/2+1:end))) ;
PNoise=repmat(PNoise,1,1,3);
Ima=im_gt+PNoise;
figure, imshow(uint8(Ima));
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [51,110;305,305;255,193;477,400]);
Ima_C=Ima_C(:,:,1);
Ima_T=Ima_T(:,:,1);
T_gt=PNoise(:,:,1);
RMSE_C=sqrt(mean((im_gt(:)-Ima_C(:)).^2))
RMSE_T=sqrt(mean((T_gt(:)-Ima_T(:)).^2))


clear all, close all;
Ima=imread('Manhattan.JPG');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [175,110;300,900]);


clear all, close all;
Ima=imread('WTC.jpg');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [390,116;440,340;160,540;922,580]); 


clear all, close all;
Ima=imread('Broadway_Crowds.jpg');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [],32,3 );


clear all, close all;
Ima=imread('fingerprint.png');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [],64,4);


clear all, close all;
Ima=imread('kodim08.png');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [90,420]);


clear all, close all;
Ima=imread('texture_smooth_e1.png');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima),[400,40],32,2,20,20);


clear all, close all;
Ima=imread('mariner04_07b.gif');
figure, imshow(uint8(Ima));
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [180,350], 32, 2, 10, 20); 


clear all, close all;
Ima=imread('mariner6.tif');
Ima=Ima(:,:,1);
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [293,137; 100,347], 64, 1, 10, 20); 


clear all, close all;
Ima=imread('Fig0519(a)(florida_satellite_original).tif');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [245,245;288,416],32,3,10,20);


clear all, close all;
Ima=imread('Rockwell - Our Heritage - 002.jpg');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [317,179; 45,843; 1105,125],32,2,30,20); 


clear all, close all;
Ima=imread('Rockwell - Carry On - 002.jpg');
figure, imshow(Ima);
[Ima_C,Ima_T]=NoLoDuDoCT( double(Ima), [] ,32,2,40,20);  


