% script_modsinewave.m
% to render a speckle image under a deformation following a 
% frequency modulated sine wave

clear all, close all;

myparamalgo = paramalgo(500,.1,'single',2^24);

myparamsensor = paramsensor(8,.7,[501,2000]);

myparamspeckle = paramspeckle('E',0.7,500000,0.8);

s = rng ; % seed for the random generator

% display the (inverse) displacement fields Ux and Uy:
display_displacement(myparamsensor.dims,@modsinewave2)

% rendering of a non-deformed speckle

rng(s)  
tic
SpeckleImage00 = SpeckleRenderGPU(myparamalgo,myparamsensor,myparamspeckle,@identity);
t1=toc;
disp(['Computation time: ',num2str(t1/60),' min.'])
SpeckleImage00_q = quantization(SpeckleImage00, myparamsensor.nbit);
imwrite(SpeckleImage00_q,'speckle00.png')
pause(600) 

rng(s) 
tic
SpeckleImage01 = SpeckleRenderGPU(myparamalgo,myparamsensor,myparamspeckle,@modsinewave2);
t2=toc;
disp(['Computation time: ',num2str(t2/60),' min.'])
SpeckleImage01_q = quantization(SpeckleImage01, myparamsensor.nbit);
imwrite(SpeckleImage01_q,'speckle01.png')
pause(600) 

save('modsinewave8.m')


