% addpath('/users/sur/expe_NoiseGen/BSpeckleRender/classes','/users/sur/expe_NoiseGen/BSpeckleRender/displacements','/users/sur/expe_NoiseGen/BSpeckleRender/functions','/users/sur/expe_NoiseGen/BSpeckleRender/scripts')

clear all 
close all

myparamalgo = paramalgo(500,0.1,'single',2^22);

myparamsensor = paramsensor(8,0.2,[101,500]);


% fine speckle pattern
%%%%%%%%%%%%%%%%%%%%%%

myparamspeckle = paramspeckle('L',5,4000,0.95,1);

s = rng ; % seed for the random generator

% display the (inverse) displacement fields Ux and Uy:
display_displacement(myparamsensor.dims,@modulatedsinewave)

% rendering non-deformed speckle
rng(s)  
tic
SpeckleImage00 = SpeckleRenderGPU(myparamalgo,myparamsensor,myparamspeckle,@identity);
t1=toc;
disp(['Computation time: ',num2str(t1/60),' min.'])
SpeckleImage00_q = quantization(SpeckleImage00, myparamsensor.nbit);
imwrite(SpeckleImage00_q,'specklefine00.png')

% rendering deformed speckle
rng(s) 
tic
SpeckleImage01 = SpeckleRenderGPU(myparamalgo,myparamsensor,myparamspeckle,@modulatedsinewave);
t2=toc;
disp(['Computation time: ',num2str(t2/60),' min.'])
SpeckleImage01_q = quantization(SpeckleImage01, myparamsensor.nbit);
imwrite(SpeckleImage01_q,'specklefine01.png') 

save('specklefine.mat')


% large speckle pattern
%%%%%%%%%%%%%%%%%%%%%%%

myparamspeckle = paramspeckle('L',20,250,0.95,1);

s = rng ; % seed for the random generator

% display the (inverse) displacement fields Ux and Uy:
display_displacement(myparamsensor.dims,@modulatedsinewave)

% rendering non-deformed speckle
rng(s)  
tic
SpeckleImage00 = SpeckleRenderGPU(myparamalgo,myparamsensor,myparamspeckle,@identity);
t1=toc;
disp(['Computation time: ',num2str(t1/60),' min.'])
SpeckleImage00_q = quantization(SpeckleImage00, myparamsensor.nbit);
imwrite(SpeckleImage00_q,'specklelarge00.png')

% rendering deformed speckle
rng(s) 
tic
SpeckleImage01 = SpeckleRenderGPU(myparamalgo,myparamsensor,myparamspeckle,@modulatedsinewave);
t2=toc;
disp(['Computation time: ',num2str(t2/60),' min.'])
SpeckleImage01_q = quantization(SpeckleImage01, myparamsensor.nbit);
imwrite(SpeckleImage01_q,'specklelarge01.png')

save('specklelarge.mat')
