/*----------------------------------------------------------------------*/
/*  Name           : algebre.c                                          */
/*  Version        : 1.0                                                */
/*  Creation       : 12/22/95                                           */
/*  Last update    : 06/06/25                                           */
/*  Subject        : Library for linear algebra                         */
/*  Author         : Yann Guermeur (Yann.Guermeur@cnrs.fr)              */
/*----------------------------------------------------------------------*/

#include <stdio.h>
#include <math.h>
#include <stddef.h>
#include <stdlib.h>

long **matrix_l(int nrow, int ncol)

/* Allocation d'une matrice Cf. Numerical Recipes in C */

{

int ind1, ind2;

long **m;

m = (long **) malloc((size_t)((nrow+1)*sizeof(long*)));
if(!m)
  {
  printf("\nallocation failure 1 in matrix()");
  exit(0);
  }

m[1] = (long *) malloc((size_t)((nrow*(ncol+1))*sizeof(long)));
if(!m[1])
  {
  printf("\nallocation failure 2 in matrix()");
  exit(0);
  }

for(ind1=2;ind1<=nrow;ind1++)
  m[ind1]=m[ind1-1]+ncol;

return m;

}

double **matrix(int nrow, int ncol)

/* Allocation d'une matrice Cf. Numerical Recipes in C */

{

int ind1, ind2;

double **m;

m = (double **) malloc((size_t)((nrow+1)*sizeof(double*)));
if(!m)
  {
  printf("\nallocation failure 1 in matrix()");
  exit(0);
  }

m[1] = (double *) malloc((size_t)((nrow*(ncol+1))*sizeof(double)));
if(!m[1])
  {
  printf("\nallocation failure 2 in matrix()");
  exit(0);
  }

for(ind1=2;ind1<=nrow;ind1++)
  m[ind1]=m[ind1-1]+ncol;

return m;

}

double gaussian(long *vect1, long *vect2, double *vect3, double **matrix1, long dim)

/* Gaussian kernel dedicated to polypeptides */

{

long ind1, ii, jj;

double result=0.0, terme_diag=0.0, terme_horsdiag=0.0;

for(ind1=1; ind1<=dim; ind1++)
  {
  ii = vect1[ind1];
  jj = vect2[ind1];

  terme_diag = matrix1[ii][ii] + matrix1[jj][jj];
  terme_horsdiag = 2.0 * matrix1[ii][jj];
  result -= vect3[ind1] * (terme_diag-terme_horsdiag);
  }

/* result /= (40 * (double)dim); */

result = exp(result);

return result;

}

void display_mat(long **mat, long dim1, long dim2, int par1)

{

long ind1, ind2;

printf("\n");

for(ind1=1;ind1<=dim1;ind1++)
  {
  for(ind2=1;ind2<=dim2;ind2++)
    printf("%*ld ",par1, mat[ind1][ind2]);
  printf("\n");
  }

printf("\n");

}
