/*----------------------------------------------------------------------*/
/*  Name           : biblio.c                                           */
/*  Version        : 1.0                                                */
/*  Creation       : 07/12/96                                           */
/*  Last update    : 06/06/24                                           */
/*  Subject        : Display the performances of a classifier           */
/*  Author         : Yann Guermeur (Yann.Guermeur@cnrs.fr)              */
/*----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "algebre.h"

void Pause(char *message)

{

char c;

static int n = 0;

if(message!=NULL)
  printf("%s\n",message);
else
  printf("\a\n=> New Line to proceed...\n");

n = read(0, &c, 1);

while(c != '\n')
  n = read(0, &c, 1);

return;

}

void display_stats(char base[], long nb_ex, long classes, 
                   long **matrice, double cout)
 
/* Affiche les statistiques obtenues en test */
 
{
 
long z, t, disp_size, nbrec=0;

double **nb, **pred, **C_matt, quotient = 0.0, **p, **o, **n, **u;

p = matrix(classes, 1);
o = matrix(classes, 1);
n = matrix(classes, 1);
u = matrix(classes, 1);
nb = matrix(classes, 1);
pred = matrix(classes, 1);
C_matt = matrix(classes, 1);

for(z=1; z<=classes; z++)
  {
  nb[z][1] = 0.0;
  pred[z][1] = 0.0;
  }

for(z=1; z<=classes; z++)
  for(t=1; t<=classes; t++)
    {
    nb[z][1] += matrice[z][t];
    pred[t][1] += matrice[z][t];
    }
 
nbrec = 0.0;

for(z=1; z<=classes; z++)
  {
  p[z][1] = matrice[z][z];
  nbrec += p[z][1];
  }
 
for(z=1; z<=classes; z++)
  u[z][1] = nb[z][1] - p[z][1];
 
for(z=1; z<=classes; z++)
  o[z][1] = pred[z][1] - p[z][1];
 
for(z=1; z<=classes; z++)
  n[z][1] = nb_ex - (pred[z][1] + u[z][1]);

for(z=1; z<=classes; z++)
  {
  quotient = (double) (n[z][1]+u[z][1]) * (n[z][1]+o[z][1]) * 
                      (p[z][1]+u[z][1]) * (p[z][1]+o[z][1]);
  if(quotient != 0.0)
    C_matt[z][1] = (p[z][1] * n[z][1] - u[z][1] * o[z][1]) / sqrt(quotient);
  else
    C_matt[z][1] = 0.0;
  }
 
disp_size = (long) ceil(log10((double) nb_ex));

printf("\nConfusion matrix:\n");

display_mat(matrice, classes, classes, disp_size);

printf("Matthews coefficients:\n\n");

for(z=1; z<=classes; z++)
  if(z<10)
    printf("C0%1ld: %6.3f\n", z, C_matt[z][1]);
  else
    printf("C%ld: %6.3f\n", z, C_matt[z][1]);
 
cout /= nb_ex;
 
printf("\n");
printf("\n          Data set: %s", base);
printf("\n  Recognition rate: %ld/%ld = %5.2lf%%", nbrec, nb_ex,
       (nbrec*100.0)/nb_ex);
printf("\n    Empirical cost: %6.4lf\n\n", cout);
 
}
