/*----------------------------------------------------------------------*/
/*  Name           : algebre.c                                          */
/*  Version        : 1.0                                                */
/*  Creation       : 12/22/95                                           */
/*  Last update    : 06/06/24                                           */
/*  Subject        : Library for linear algebra                         */
/*  Author         : Yann Guermeur (Yann.Guermeur@cnrs.fr)              */
/*----------------------------------------------------------------------*/

#include <stdio.h>
#include <math.h>
#include <stddef.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

long **matrix_l(int nrow, int ncol)

/* Allocation of a matrix of longs (Cf. Numerical Recipes in C) */

{
int ind1;
long **m;

m = (long **) malloc((size_t)((nrow+1)*sizeof(long*)));
if(!m)
  {
  printf("\nallocation failure 1 in matrix()");
  exit(0);
  }

m[1] = (long *) malloc((size_t)((nrow*(ncol+1))*sizeof(long)));
if(!m[1])
  {
  printf("\nallocation failure 2 in matrix()");
  exit(0);
  }

for(ind1=2;ind1<=nrow;ind1++)
  m[ind1]=m[ind1-1]+ncol;

return m;

}

double **matrix(int nrow, int ncol)

/* Allocation of a matrix of doubles (Cf. Numerical Recipes in C) */

{
int ind1;
double **m;

m = (double **) malloc((size_t)((nrow+1)*sizeof(double*)));
if(!m)
  {
  printf("\nallocation failure 1 in matrix()");
  exit(0);
  }

m[1] = (double *) malloc((size_t)((nrow*(ncol+1))*sizeof(double)));
if(!m[1])
  {
  printf("\nallocation failure 2 in matrix()");
  exit(0);
  }

for(ind1=2;ind1<=nrow;ind1++)
  m[ind1]=m[ind1-1]+ncol;

return m;

}

void sub_vects(double *vect1, double *vect2, double *vect3, int dim1)
 
/* Subtraction of two matrices */
 
{
 
int ind1;

for(ind1=1;ind1<=dim1;ind1++)
    vect3[ind1] = vect1[ind1] - vect2[ind1]; 
}

void add_vects(double *vect1, double *vect2, int dim1)
 
/* Addition of two vectors, resultat stored in the first one */
 
{
 
long ind1;

for(ind1=1;ind1<=dim1;ind1++)
  vect1[ind1] += vect2[ind1];
 
}

void mult_mat_vect(double **mat1, double *vect1, double *vect2,
                 int dim1, int dim2)
 
/* Product of a matrix and a vector */
 
{
 
int ind1, ind2;

for(ind1=1;ind1<=dim1;ind1++)
  {
  vect2[ind1] = 0.0;
  for(ind2=1;ind2<=dim2;ind2++)
    vect2[ind1] += mat1[ind1][ind2] * vect1[ind2];
  }
 
}

void display_mat(long **mat, long dim1, long dim2, int par1)

/* Display a matrix */

{

long ind1, ind2;

printf("\n");

for(ind1=1;ind1<=dim1;ind1++)
  {
  for(ind2=1;ind2<=dim2;ind2++)
    printf("%*ld ", par1, mat[ind1][ind2]);
  printf("\n");
  }

printf("\n");

}

double tanh_prim(double value)

/* Computation of the derivative of the function tanh */

{

double result;

result = (1.0 + value) * (1.0 - value);
return result;

}
