#/usr/bin/python3 
# derived from a script by T. Malliavin

import numpy as np
import math
from numpy import linalg as LA
from numpy.linalg import inv
# ./extract_blosum.py

aa=np.loadtxt("./matrix.txt")
aa=math.log(2)*aa/2
bb=np.exp(aa)

#bb=np.loadtxt("./matrix.txt")

eigenvalues, eigenvectors = LA.eig(bb)

print("eigenvalues",eigenvalues)

cc = np.diag(eigenvalues)
dd = np.matmul(eigenvectors,cc)
ee = np.linalg.inv(eigenvectors)
ff = np.matmul(dd,ee)
print("np.max(ff-bb)",np.max(ff-bb))
print("np.min(ff-bb)",np.min(ff-bb))

for ii in range(ff.shape[0]):
  print("eigenvalue",eigenvalues[ii])
  eigenvalues[ii] = max(eigenvalues[ii], 0.0)

cc = np.diag(eigenvalues)
dd = np.matmul(eigenvectors,cc)
ee = np.linalg.inv(eigenvectors)
ff = np.matmul(dd,ee)

print("ff max",np.max(ff),"min",np.min(ff))
print("ff.shape",ff.shape)

np.savetxt("projected_matrix.txt",ff,fmt='%.5e', delimiter=' ', newline='\n')
